#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

## IMPORTANT ##
# When Net::Twitter::Lite encounters a Twitter API error or a network error, 
# it throws a Net::Twitter::Lite::Error object. 
# You can catch and process these exceptions by using eval blocks and testing $@
## from http://search.cpan.org/perldoc?Net::Twitter::Lite#ERROR_HANDLING
use Net::Twitter::Lite::WithAPIv1_1;
use Data::Dumper;

my $bot = Net::Twitter::Lite::WithAPIv1_1->new(
    legacy_lists_api => 0,
);

my $dump;
if (defined $ARGV[0] and $ARGV[0] eq "-d") {
    $dump = shift @ARGV;
}

eval {
    foreach my $id (@ARGV) {
        $id =~ /\/?(\d+)$/;
        $id = $1;
        my $res = $bot->show_status($id);
        foreach my $line (split /\n/, Dumper $res) {
            if ($line =~ /undef/) { next; }
            if (! $dump) {
                unless ($line =~ / => {/
                    ||  $line =~ / = /
                    ||  $line =~ /status/
                    ||  $line =~ /'text'/
                    ||  $line =~ /created/
                    ||  $line =~ /'id'/
                    ||  $line =~ /name/
                    ||  $line =~ / },/
                    ||  $line =~ / };/
                ) { next; }
            }
            print $line, "\n";
        }
    }
};
if ($@) {
    evalrescue($@);
}


sub evalrescue {
    # output error message at eval error
    
    use Scalar::Util qw(blessed);
    
    if (blessed $@ && $@->isa('Net::Twitter::Lite::Error')) {
        warn $@->error;
        if ($@->twitter_error) {
            my $twitter_error = $@->twitter_error;
            if (defined $twitter_error->{errors}) {
                foreach my $error (@{$twitter_error->{errors}}) {
                    warn "code => "   , $error->{code}, "\n";
                    warn "message => ", $error->{message}, "\n";
                }
            }
            else {
                # unknown HASH structure
                use Data::Dumper;
                warn Dumper $twitter_error;
            }
        }
    }
    else {
        warn $@;
    }
}
