#!/bin/sh

set -x
export LANG=C

PROJECT_NAME="${1:?"usage: $0 <PROJECT_NAME> <SUB_ROOTDIR> [-noinit] "}"
SUB_ROOTDIR="${2:?"usage: $0 <PROJECT_NAME> <SUB_ROOTDIR> [-noinit] "}"

# stop script if "$1" exists
isexist () {
    if [ -e "$1" ] ; then
        echo "$1" already exists
        exit
    fi
}

# set global environments
NEWREPOS="/var/svn/${SUB_ROOTDIR}/${PROJECT_NAME}"
REPOSBACKUP="/var/backups/svn/${SUB_ROOTDIR}/${PROJECT_NAME}"

HOOKSKEL="/home/tools/svn/hooks"

# check paths to be created
isexist ${NEWREPOS}
isexist ${REPOSBACKUP}

# make repos
mkdir -p ${NEWREPOS}
svnadmin create --fs-type fsfs ${NEWREPOS}
for HOOK in `ls ${HOOKSKEL}`; do
  ln -s ${HOOKSKEL}/${HOOK} ${NEWREPOS}/hooks
done
mkdir -p ${NEWREPOS}/dav
chgrp -R www-data ${NEWREPOS}
chmod -R o-rw ${NEWREPOS}
chmod -R g+ws ${NEWREPOS}/db
chmod -R g+ws ${NEWREPOS}/dav

# make repos backup
mkdir -p ${REPOSBACKUP}/incremental
chgrp -R www-data ${REPOSBACKUP}
chmod -R g+ws ${REPOSBACKUP}

if [ "$3" != "-noinit" ]; then
    # initial commit
    svn mkdir -m "REPOS init." file://${NEWREPOS}/trunk file://${NEWREPOS}/tags file://${NEWREPOS}/branches file://${NEWREPOS}/vendor
fi


echo "done"
echo "${NEWREPOS} ${REPOSBACKUP} are created"
