#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

use Encode;
use Unicode::Normalize qw(NFC);

my $top = shift @ARGV || exit;
if (! -d $top) { exit; }

my $utf8 = find_encoding("utf8");

checkdir($top);

sub match {
    my $str = shift @_;
    
    $str = $utf8->decode($str);
    if ($str ne NFC($str)) {
        return 1;
    }
    
    return '';
}

sub checkdir {
    my $target = shift @_;
    
    print STDERR "# checking '$target'\n";
    opendir(my $dir, $target) || return $target;
    my @entries = sort grep { !m/^(\.|\.\.)$/g } readdir($dir);
    closedir($dir);
    
    my @dirs;
    while (my $entry = shift @entries) {
        if (match($entry)) {
            print "'$target/$entry' can be composed\n";
            next;
        }
        if (-d "$target/$entry") {
            push @dirs, $entry;
            next;
        }
    }
    
    while (my $entry = pop @dirs) {
        checkdir("$target/$entry");
    }
}
