#!/bin/sh

set -x
export LANG=C

PROJECT_NAME="${1:?"usage: $0 <PROJECT_NAME> <SUB_ROOTDIR> <SUBDOMAIN> "}"
SUB_ROOTDIR="${2:?"usage: $0 <PROJECT_NAME> <SUB_ROOTDIR> <SUBDOMAIN> "}"
SUBDOMAIN="${3:?"usage: $0 <PROJECT_NAME> <SUB_ROOTDIR> <SUBDOMAIN> "}"

# stop script if "$1" exists
isexist () {
    if [ -e "$1" ] ; then
        echo "$1" already exists
        exit
    fi
}

# set global environments
NEWTRAC="/var/trac/${SUB_ROOTDIR}/${PROJECT_NAME}"
TRACBACKUP="/var/backups/trac/${SUB_ROOTDIR}/${PROJECT_NAME}"
TRACINI="/home/tools/tool/trac.ini.build"
SVNPATH="/var/svn/${SUB_ROOTDIR}/${PROJECT_NAME}"

# check paths to be created
isexist ${NEWTRAC}
isexist ${TRACBACKUP}

# make trac
mkdir -p ${NEWTRAC}
trac-admin ${NEWTRAC} initenv ${PROJECT_NAME} sqlite:db/trac.db svn ${SVNPATH}
trac-admin ${NEWTRAC} permission add mitty TRAC_ADMIN
chgrp -R www-data ${NEWTRAC}
chmod -R o-rw ${NEWTRAC}
chmod -R g-w ${NEWTRAC}
chmod -R g+w ${NEWTRAC}/attachments
chmod -R g+w ${NEWTRAC}/db
chmod -R g+w ${NEWTRAC}/log

# make trac backup
mkdir -p ${TRACBACKUP}
chgrp -R www-data ${TRACBACKUP}
chmod -R g+ws ${TRACBACKUP}

# modify trac.ini
mv ${NEWTRAC}/conf/trac.ini ${NEWTRAC}/conf/trac.ini.original
cp ${TRACINI} ${NEWTRAC}/conf/trac.ini
sed -i s#PROJECT_NAME#${PROJECT_NAME}#g ${NEWTRAC}/conf/trac.ini
sed -i s#SUBDOMAIN#${SUBDOMAIN}#g ${NEWTRAC}/conf/trac.ini
sed -i s#SUB_ROOTDIR#${SUB_ROOTDIR}#g ${NEWTRAC}/conf/trac.ini
sed -i s#SVNPATH#${SVNPATH}#g ${NEWTRAC}/conf/trac.ini
chgrp -R www-data ${NEWTRAC}/conf/trac.ini
chmod -R g+w ${NEWTRAC}/conf/trac.ini
chmod    g+w ${NEWTRAC}/conf


echo "done"
echo "${NEWTRAC} ${TRACBACKUP} are created"
