#! /usr/bin/perl -w

use warnings;
use strict;

use Regexp::Assemble;

if ($#ARGV + 1 < 1) {
    print "$0: list_of_regex [filter_target]\n";
    exit 0;
}

my $regexfile = shift @ARGV;
if (! -r $regexfile) {
    warn "$0: cannot read '$regexfile'";
    exit 1;
}

my $re = Regexp::Assemble->new(file => "$regexfile");

my $target = shift @ARGV;

my $input;
unless (defined($target) and -f $target) {
    print STDERR "read from STDIN\n";
    $input = *STDIN;
}
else {
    open $input, "<$target";
}

my $line;
while ($line = <$input>) {
    chomp $line;
    if ($re->match($line)) {
        print "OK: ";
    }
    else {
        print "NG: ";
    }
    print $line, "\n";
}
