#!/usr/bin/perl -w

use strict;
use warnings;
use utf8;

use Crypt::SSLeay;
use LWP::UserAgent;
use HTTP::Request::Common;
use YAML::Tiny;
use FindBin qw($Bin);

my $conf = YAML::Tiny->read("$Bin/checkalive.yml")->[0];

my $ua = LWP::UserAgent->new;

foreach my $url (@{$conf->{urls}}) {
    my $response = $ua->request(GET $url);
    logging($response->status_line, " ", $url);
}

sub logging {
    my (@msg) = @_;
    
    my $logfile = "$Bin/checkalive." . today() . ".log";
    open LOG, ">>$logfile";
    print LOG "[" . localtime() . "] ($$) " , @msg, "\n";
    close LOG;
}

sub today {
    my ($s, $mi, $h, $d, $mo, $y, $w) = localtime();
    $mo++; $y += 1900;
    return sprintf("%4d%02d%02d", $y, $mo, $d, $h, $mi, $s);
}
