#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;
use encoding 'utf-8';

use Unicode::Japanese qw(unijp);

my $top = shift @ARGV || exit;
if (! -d $top) { exit; }

checkdir($top);

sub match {
    my $str = shift @_;
    
    my $sjis = unijp($str)->sjis;
    if ($sjis =~ /&#\d{4,};/) {
        return 1;
    }
    
    return '';
}

sub checkdir {
    my $target = shift @_;
    
    print STDERR "checking '$target'\n";
    opendir(my $dir, $target) || return $target;
    my @entries = sort readdir($dir);
    closedir($dir);
    
    my @dirs;
    while (my $entry = shift @entries) {
        next if ($entry =~ /^\.+$/);
        if (match($entry)) {
            print "'$target/$entry' contains non Shift_JIS character\n";
            next;
        }
        if (-d "$target/$entry") {
            push @dirs, $entry;
            next;
        }
    }
    
    while (my $entry = pop @dirs) {
        checkdir("$target/$entry");
    }
}
