#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

use Encode;

my $top = shift @ARGV || exit;
if (! -d $top) { exit; }

my $utf8 = find_encoding("utf8");

checkdir($top);

sub match {
    my $str = shift @_;
    
    my $sjis = encode("cp932", $utf8->decode($str), Encode::FB_HTMLCREF);
    if ($sjis =~ /&#\d{4,};/) {
        Encode::from_to($sjis, "cp932", "utf8");
        return $sjis;
    }
    
    return '';
}

sub checkdir {
    my $target = shift @_;
    
    print STDERR "# checking '$target'\n";
    opendir(my $dir, $target) || return $target;
    my @entries = sort grep { !m/^(\.|\.\.)$/g } readdir($dir);
    closedir($dir);
    
    my @dirs;
    while (my $entry = shift @entries) {
        if (my $convert = match($entry)) {
            print "'$target/$entry' can be converted to '$convert'\n";
            next;
        }
        if (-d "$target/$entry") {
            push @dirs, $entry;
            next;
        }
    }
    
    while (my $entry = pop @dirs) {
        checkdir("$target/$entry");
    }
}
