#!/bin/sh

set -x

IF="${1:?"usage: $0 <ether_device> [gateway] "}"
GATEWAY=$2

TID=`/sbin/ip addr show dev ${IF} | grep -w ${IF}: | cut -d : -f 1`

if [ "${GATEWAY}" = "down" ]; then
    # delete routing table and policy and exit
    ## routing table is automatically flushed, so 'route flush' can be removed
    /sbin/ip route flush table ${TID}
    ## device has no longer any IP addr, so do not use IPADDR
    /sbin/ip rule del table ${TID} priority ${TID}
    /sbin/ip route flush cache
    echo "remove routing table and policy for ${IF}"
    exit
fi


# get IP address, network mask, default gateway info
IPADDR=`/sbin/ip addr show dev ${IF} | grep -w inet | cut -d t -f 2 | cut -d ' ' -f 2 | cut -d / -f 1`
NETWORK=`/sbin/ip route show dev ${IF} | grep -w ${IPADDR} | cut -d ' ' -f 1`

if [ -z "${GATEWAY}" ]; then
    GATEWAY=`/sbin/ip route show dev ${IF} | grep -w default | cut -d ' ' -f 3`
fi
if [ -z "${GATEWAY}" ]; then
    GATEWAY=`/sbin/ip route | grep -w default | cut -d ' ' -f 3`
    # this may add wrong default route especially on RHEL
fi


# set routing table
/sbin/ip route add ${NETWORK} dev ${IF} table ${TID}
/sbin/ip route add default via ${GATEWAY} dev ${IF} table ${TID}

# set routing policy
/sbin/ip rule add from ${IPADDR} table ${TID} priority ${TID}

/sbin/ip route flush cache
echo "add routing table and policy for ${IF} on table ${TID}"
