#! /usr/bin/perl -w

use strict;
use warnings;

my $exec = 'dumptorrent-1.2.exe';

my $torrent = shift @ARGV;

if (! -f $torrent) {
    die "$0: file doesn't exit: $torrent";
}

my @output = `$exec "$torrent" 2>&1`;

my ($name, @files);

while (my $line = shift @output) {
    
    if (!$name and $line =~ /^Name:\s+(.*)$/) {
        $name = $1;
    }
    if ($line =~ /^Files:/) {
        while ($line = shift @output) {
            if ($line =~ /^\s+(.+\w)\s+\d+( \([0-9\.]+[KM]\))?$/) {
                push (@files, $1);
            }
        }
    }
}

foreach my $file (@files) {
    print "$torrent\t$name\t$file\n";
}
