#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

use Encode;
use Kanconvit;  # http://kanconvit.ta2o.net/

my $top = shift @ARGV || exit;
if (! -d $top) { exit; }

my $utf8 = find_encoding("utf8");
my $ck = Kanconvit->new();

checkdir($top);

sub match {
    my $str = shift @_;
    
    $str = $utf8->decode($str);
    my $sjis = encode("cp932", $str, Encode::FB_HTMLCREF);
    if ($sjis =~ /&#\d{4,};/) {
        my $jtext = $ck->conv_c2j($str);
        if ($str ne $jtext) {
            return $utf8->encode($jtext);
        }
    }
    
    return '';
}

sub checkdir {
    my $target = shift @_;
    
    print STDERR "# checking '$target'\n";
    opendir(my $dir, $target) || return $target;
    my @entries = sort grep { !m/^(\.|\.\.)$/g } readdir($dir);
    closedir($dir);
    
    my @dirs;
    while (my $entry = shift @entries) {
        if (my $japanese = match($entry)) {
            print "mv '$target/$entry' \\\n";
            print "   '$target/$japanese'\n";
            next;
        }
        if (-d "$target/$entry") {
            push @dirs, $entry;
            next;
        }
    }
    
    while (my $entry = pop @dirs) {
        checkdir("$target/$entry");
    }
}
