#!/bin/sh

# enable access to WAN device on router node from LAN clients
#

set -x

## INTERFACES(5)
# IFACE  physical name of the interface being processed
# METHOD method of the interface (e.g., static)
# MODE   start if run from ifup, stop if run from ifdown
# PHASE  as per MODE, but with finer granularity, distinguishing the pre-
#        up, post-up, pre-down and post-down phases.

LANIF="${1:?"usage: $0 <LAN_device> <IPADDR> "}"
LANIP="${2:?"usage: $0 <LAN_device> <IPADDR> "}"

WANIP=`/sbin/ip addr show dev ${IFACE} | grep -w inet | tr -s ' ' | cut -d ' ' -f 3 | cut -d / -f 1`

if [ "${PHASE}" = "pre-down" ]; then
    # delete rule and exit
    /sbin/iptables -t nat -D PREROUTING -i ${LANIF} -d ${WANIP} -j DNAT --to-destination ${LANIP}
    echo "remove rule for access to WAN device on router node from LAN clients"
    exit
fi


# set rule
(
sleep 60

/sbin/iptables -t nat -A PREROUTING -i ${LANIF} -d ${WANIP} -j DNAT --to-destination ${LANIP}
echo "set rule for access to WAN device on router node from LAN clients"

) &
