#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

## IMPORTANT ##
# When Net::Twitter::Lite encounters a Twitter API error or a network error, 
# it throws a Net::Twitter::Lite::Error object. 
# You can catch and process these exceptions by using eval blocks and testing $@
## from http://search.cpan.org/perldoc?Net::Twitter::Lite#ERROR_HANDLING
use Net::Twitter::Lite;
use Data::Dumper;

my $bot = Net::Twitter::Lite->new;

eval {
    foreach my $id (@ARGV) {
        my $res = $bot->show_status($id);
        foreach my $line (split /\n/, Dumper $res) {
            if ($line =~ /undef/) { next; }
            unless ($line =~ / => {/
                ||  $line =~ / = /
                ||  $line =~ /status/
                ||  $line =~ /'text'/
                ||  $line =~ /created/
                ||  $line =~ /'id'/
                ||  $line =~ /name/
                ||  $line =~ / },/
                ||  $line =~ / };/
            ) { next; }
            print $line, "\n";
        }
    }
};
if ($@) {
    evalrescue($@);
}
print "truncated output done\n";


sub evalrescue {
    # output error message at eval error
    
    use Scalar::Util qw(blessed);
    
    if (blessed $@ && $@->isa('Net::Twitter::Lite::Error')) {
        warn $@->error;
        if ($@->twitter_error) {
            my %twitter_error = %{$@->twitter_error};
            map {
                $twitter_error{"$_ => "} = $twitter_error{$_} . "\n";
                delete $twitter_error{$_}
            } keys %twitter_error;
            warn join("", %twitter_error);
        }
    }
    else {
        warn $@;
    }
}
