#!/usr/bin/env perl
use strict;
use warnings;
use utf8;
use Net::Twitter;

use YAML::Tiny;
my $config = (YAML::Tiny->read('config.yml'))->[0];

my $consumer_key = $config->{'consumer_key'};
my $consumer_key_secret = $config->{'consumer_secret'};
my $access_token = $config->{'access_token'};
my $access_token_secret = $config->{'access_token_secret'};

my $nt = Net::Twitter->new(
  traits          => ['API::REST', 'OAuth'],
  consumer_key    => $consumer_key,
  consumer_secret => $consumer_key_secret,
);
$nt->access_token($access_token);
$nt->access_token_secret($access_token_secret);

my $res = $nt->update({ status => "Perl から Twiitter を更新するテストですよー" });
