#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;
use encoding 'utf-8';

use Unicode::Normalize qw(NFC NFKC);

my $top = shift @ARGV || exit;
if (! -d $top) { exit; }

checkdir($top);

sub combinable {
    my $str = shift @_;
    
    if ($str ne NFC($str)) {
        return 1;
    }
    if ($str ne NFKC($str)) {
        return 1;
    }
    
    return '';
}

sub checkdir {
    my $target = shift @_;
    
    print STDERR "checking '$target'\n";
    opendir(my $dir, $target) || return $target;
    my @entries = sort readdir($dir);
    closedir($dir);
    
    my @dirs;
    while (my $entry = shift @entries) {
        next if ($entry =~ /^\.+$/);
        if (combinable($entry)) {
            print "'$target/$entry' can be composed\n";
            next;
        }
        if (-d "$target/$entry") {
            push @dirs, $entry;
            next;
        }
    }
    
    while (my $entry = pop @dirs) {
        checkdir("$target/$entry");
    }
}
