#! /usr/bin/perl -w

use strict;
use warnings;

use Net::BitTorrent::File;
use Data::Dumper;

my $torretfile = shift @ARGV;
my $torrent = Net::BitTorrent::File->new($torretfile) or
    die "$0: cannot load torrent file: $torretfile";

my $files = $torrent->files;
if ($files) {
    foreach my $file (@$files) {
        if (exists $file->{'path.utf-8'}) {
            print $torrent->name, "/", join ("/", @{ $file->{'path.utf-8'} }), "\n";
        }
        else {
            print $torrent->name, "/", join ("/", @{ $file->{'path'} }), "\n";
            
        }
    }
}
else {
    print $torrent->name, "\n";
}
