#! /usr/bin/perl -w

use strict;
use warnings;
use utf8;

use LWP::UserAgent;
use Encode;
use Encode::Guess qw/shift-jis euc-jp 7bit-jis/;
use File::Temp qw/ :POSIX /;

my $target = shift @ARGV || die "$0: URL or file-of-url-list [coding]\n";
my $coding = shift @ARGV || 'utf8';

my $ua  = LWP::UserAgent->new;

my @URLs;
if ($target !~ /^http/ && -f $target) {
    open(my $fh, "<$target");
    @URLs = <$fh>;
}
else {
    push @URLs, $target;
}

foreach my $url (@URLs) {
    chomp $url;
    my $tmpfile = tmpnam();
    my $res = $ua->mirror($url, $tmpfile);
    
    if ($res->is_success) {
        my $filename = $res->filename;
        my $decoder = Encode::Guess->guess($filename);
        if (ref($decoder)) {
            print $decoder->name;
            $filename = encode(
                $coding,
                $decoder->decode($filename),
                Encode::FB_HTMLCREF
            );
        }
        else {
            print "utf8?";
            $filename = encode(
                $coding,
                decode("utf8", $filename),
                Encode::FB_HTMLCREF
            );
        }
        print ": $filename\n";
        
        my $suffix = 1;
        my $savename = $filename;
        while (-e $savename) {
            $savename = "$filename.$suffix";
            $suffix++;
        }
        rename($tmpfile, $savename);
    }
    else {
        unlink($tmpfile);
    }
}
