#!/bin/sh

# set IP MASQUERADE for listed devices
# this script must be set on the LAN gateway device


set -x

## INTERFACES(5)
# IFACE  physical name of the interface being processed
# METHOD method of the interface (e.g., static)
# MODE   start if run from ifup, stop if run from ifdown
# PHASE  as per MODE, but with finer granularity, distinguishing the pre-
#        up, post-up, pre-down and post-down phases.

# optional argument to set default gateway devices connected to WAN manually
# (try each of them in order)
GATEWAYS="$@"

if [ "${PHASE}" = "post-down" ]; then
    # flush POSTROUTING chain and exit
    /sbin/iptables -t nat -F POSTROUTING
    exit
fi


(

# wait for initialization of WAN device with DHCPd 
sleep 60

if [ -z "${GATEWAYS}" ]; then
    GATEWAYS=`/sbin/ip route show table main | grep -w default | cut -d ' ' -f 5`
fi

for GW in ${GATEWAYS}; do
    if [ ${GW} = ${IFACE} ]; then
        # skip if device is the LAN gateway
        continue
    fi
    
    IPADDR=`/sbin/ip addr show dev ${GW} | grep -w inet | cut -d t -f 2 | cut -d ' ' -f 2 | cut -d / -f 1`
    if [ -z "${IPADDR}" ]; then
        # device doesn't seem to have an IP address
        continue
    fi
    
    ## set masquerade rule to all devices
    #  because there is no way to know which one is default gateway
    #  without manual specification
    /sbin/iptables -t nat -A POSTROUTING -o ${GW} -j MASQUERADE
done

) &
