#!/bin/sh

# set IP MASQUERADE with post-up command in INTERFACES(5)


set -x

## INTERFACES(5)
# IFACE  physical name of the interface being processed
# METHOD method of the interface (e.g., static)
# MODE   start if run from ifup, stop if run from ifdown
# PHASE  as per MODE, but with finer granularity, distinguishing the pre-
#        up, post-up, pre-down and post-down phases.

# optional argument to set default gateway devices connected to WAN manually
# (try each of them in order)

if [ "${PHASE}" = "post-down" ]; then
    # remove MASQUERADE rule and exit
    /sbin/iptables -t nat -D POSTROUTING -o ${IFACE} -j MASQUERADE
    exit
fi


# set MASQUERADE rule
/sbin/iptables -t nat -A POSTROUTING -o ${IFACE} -j MASQUERADE
