#!/usr/bin/env perl
use strict;
use warnings;
use utf8;
use Net::Twitter;

use YAML::Tiny;
my $config = (YAML::Tiny->read('config.yml'))->[0];

my $consumer_key = $config->{'consumer_key'};
my $consumer_key_secret = $config->{'consumer_key_secret'};
my $access_token = $config->{'access_token'};
my $access_token_secret = $config->{'access_token_secret'};

my $nt = Net::Twitter->new(
  traits          => ['API::REST', 'OAuth'],
  consumer_key    => $consumer_key,
  consumer_secret => $consumer_key_secret,
);
print 'access this url by bot account : '.$nt->get_authorization_url."\n";
print 'input verifier PIN : ';
my $verifier = <STDIN>;
chomp $verifier;

my $token = $nt->request_token;
my $token_secret = $nt->request_token_secret;

$nt->request_token($token);
$nt->request_token_secret($token_secret);

my($at, $ats) = $nt->request_access_token(verifier => $verifier);

print "Access token : ".$at."\n";
print "Access token secret : ".$ats."\n";
